package com.icetech.partner.domain.constant;

import lombok.Getter;

/**
 *
 * @author fangct
 */
@Getter
public enum JinyiEtcMethodEnum {
    heartbeat("etc.heartbeat", "etc.heartbeat.response"),
    deductFinish("etc.deduct.finish", null),
    deduct("etc.deduct", "etc.deduct.response"),
    obuUpload("obu.upload", "obu.upload.response");

    private String method;
    private String responseMethod;

    JinyiEtcMethodEnum(String method, String responseMethod) {
        this.method = method;
        this.responseMethod = responseMethod;
    }

    public static String getResponseMethodByMethod(String method) {
        JinyiEtcMethodEnum[] etcMethodEnums = JinyiEtcMethodEnum.values();
        for (JinyiEtcMethodEnum etcMethodEnum : etcMethodEnums) {
            if (etcMethodEnum.getMethod().equals(method)) {
                return etcMethodEnum.getResponseMethod();
            }
        }
        return null;
    }
}
