package com.icetech.partner.api.response.open.teld;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class AuthResultRespData implements Serializable {
    /**
     * <p>成功状态</p>
     * <p>0：成功；1：失败</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected Integer succStat;
    /**
     * <p>充电订单号</p>
     * <p>充电运营商订单号，特来电的格式：8位日期+10位序列号，用来识别停车票订单</p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected String startChargeSeq;
    /**
     * <p>车牌号</p>
     * <p></p>
     * <p>必填: 是</p>
     * <p>长度: </p>
     */
    protected String plateNum;
    /**
     * <p>失败原因</p>
     * <dl>
     *     <dt>失败原因：</dt>
     *     <dd>0：无</dd>
     *     <dd>1：停车票已使用</dd>
     *     <dd>2：停车票已作废</dd>
     *     <dd>3：停车票不存在</dd>
     *     <dd>4：停车票已过期</dd>
     * </dl>
     * <p>必填: 否</p>
     * <p>长度: </p>
     */
    protected Integer failReason;
}
