package com.icetech.partner.api.response.business;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;

/**
 *  月卡产品表
 *
 *  @author wanggy 
 */
@Data
public class QueryMonthProductResponse implements Serializable {

    /**
     * id
     */
    @ApiModelProperty(value = "月卡套餐编号", required = true, example = "1", position = 1)
    private String productId;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "月卡产品名称", required = true, example = "月卡999", position = 2)
    private String productName;
  
    /**
     * 产品面额（1个月2个月等）
     */
    @ApiModelProperty(value = "产品面额", required = true, example = "1", position = 3)
    private Integer duration;

    /**
     * 销售金额
     */
    @ApiModelProperty(value = "销售金额", required = true, example = "100", position = 4)
    private String payMoney;

    /**
     * 月卡产品类型（1全天2分时段）
     */
    @ApiModelProperty(value = "月卡产品类型（1全天2分时段）", required = true, example = "1", position = 6)
    private String cardType;

    /**
     * 可用开始时间2018-10-31
     */
    @ApiModelProperty(value = "可用开始时间", required = true, example = "2022-07-01", position = 7)
    private String startDate;

    /**
     * 可用结束时间2018-10-31
     */
    @ApiModelProperty(value = "可用结束时间", required = true, example = "2022-07-31", position = 8)
    private String endDate;

    /**
     * 开始时间点 （月卡分时段时此参数必填产品可用时间段21:00:00）
     */
    @ApiModelProperty(value = "开始时间点 （月卡分时段时此参数必填产品可用时间段21:00:00）", example = "21:00:00", position = 9)
    private String startTime;

    /**
     * 结束时间点（跨天开始>结束，例如09:00:00）
     */
    @ApiModelProperty(value = "结束时间点（跨天开始>结束，例如09:00:00）", example = "21:00:00", position = 9)
    private String endTime;

    /**
     * 购买渠道 0：仅平台可购买 1：平台和公众号均可购买 
     */
    @ApiModelProperty(value = "购买渠道 0：仅平台可购买 1：平台和公众号均可购买", required = true, example = "1", position = 10)
    private Integer buyWay;

    /**
     * 套餐所售状态 1 在售 2 停售 3 过期
     */
    @ApiModelProperty(value = "套餐所售状态 1 在售 2 停售 3 过期", required = true, example = "1", position = 11)
    private Integer productStatus;

}
