package com.icetech.partner.api.response.business;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description QueryMonthCardsResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/11 17:41
 */
@Data
public class QueryMonthCardsResponse implements Serializable {

    @ApiModelProperty(value = "查询月卡总数", required = true, example = "10", position = 1)
    private String totalSize;

    @ApiModelProperty(value = "查询月卡列表", required = true, example = "10", position = 2)
    private List<MonthCards> mothCards;
    
    @Data
    public static class MonthCards implements Serializable {

        @ApiModelProperty(value = "月卡记录编号", required = true, example = "10", position = 1)
        private Long cardId;

        @ApiModelProperty(value = "月卡套餐编号", required = true, example = "111", position = 2)
        private String productId;

        @ApiModelProperty(value = "月卡套餐名称", required = true, example = "年卡999", position = 3)
        private String prodName;

        @ApiModelProperty(value = "月卡申办性质，详情查看数据定义部分", required = true, example = "年卡999", position = 4)
        private Integer cardProperty;

        @ApiModelProperty(value = "用户/公司名称", required = true, example = "智芯原动", position = 5)
        private String cardOwner;

        @ApiModelProperty(value = "车牌号，（多个以 / 分割）", required = true, example = "京A88888", position = 6)
        private String plateNum;

        @ApiModelProperty(value = "手机号", required = true, example = "13888888888", position = 7)
        private String phone;

        @ApiModelProperty(value = "车位数量，默认为1，可支持多车位多车", required = true, example = "10", position = 8)
        private Integer plotCount;

        @ApiModelProperty(value = "车位号 多个以”/“连接", required = true, example = "A1001", position = 9)
        private String plotNum;

        @ApiModelProperty(value = "月卡有效开始日期，格式为年-月-日", required = true, example = "2022-07-01", position = 10)
        private String startTime;

        @ApiModelProperty(value = "月卡有效结束日期，格式为年-月-日", required = true, example = "2022-07-30", position = 11)
        private String endTime;

        @ApiModelProperty(value = "卡状态（1：正常，2：禁用）", required = true, example = "1", position = 12)
        private Integer cardStatus;

        @ApiModelProperty(value = "月卡区域", required = true, example = "", position = 12)
        private List<RegionData> regionData;
        
        @Data
        public static class RegionData implements Serializable {

            @ApiModelProperty(value = "区域编号", required = true, example = "A00001", position = 1)
            private String regionCode;

            @ApiModelProperty(value = "区域名称", required = true, example = "昌平", position = 2)
            private String regionName;
        }
        
    }
}
