package com.icetech.partner.api.response.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Description SaveParkResponse
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/14 10:01
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ParkBaseInfoResponse implements Serializable {

    @ApiModelProperty(value = "停车场编号", example = "P1515151", required = true, position = 1)
    private String parkCode;

    @ApiModelProperty(value = "停车场名称", example = "test001", required = true, position = 2)
    private String parkName;

    @ApiModelProperty(value = "电话", example = "15132312345", required = false, position = 3)
    private String telphone;

    @ApiModelProperty(value = "省份", example = "河北", required = false, position = 4)
    private String provinceName;

    @ApiModelProperty(value = "城市", example = "张家口", required = false, position = 5)
    private String cityName;

    @ApiModelProperty(value = "地区", example = "阳原", required = false, position = 6)
    private String  districtName;

    @ApiModelProperty(value = "总车位数", example = "100", required = true, position = 7)
    private Integer totalPark;

    @ApiModelProperty(value = "车场地址", example = "北京市昌平区沙河地铁东200米凌一停车场", required = false, position = 8)
    private String address;

    @ApiModelProperty(value = "车场纬度", example = "3.14", required = false, position =9)
    private String lat;

    @ApiModelProperty(value = "车场经度", example = "3.14", required = false, position =10)
    private String lng;

    @ApiModelProperty(value = "车场状态:1启用;0禁用", example = "0", required = false, position =11)
    private String status;

    @ApiModelProperty(value = "是否存在场中场:0否;1是;默认0", example = "0", required = false, position =12)
    private Integer isInterior;

    @ApiModelProperty(value = "场中场切换免费时长 分钟", example = "0", required = false, position =13)
    private Integer switchFeeTime;

    @ApiModelProperty(value = "出口数量", example = "0", required = false, position =14)
    private Integer totalExit;

    @ApiModelProperty(value = "入口数量", example = "0", required = false, position =15)
    private Integer totalEnter;

    @ApiModelProperty(value = "停车场属性", example = "1", required = false, position =16)
    private String parkProperty;
}
