package com.icetech.partner.api.response.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wanggang
 * @create 2022-07-18 15:52
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ChannelDeviceResponse implements Serializable {

    @ApiModelProperty(value = "通道编号", example = "C111", required = true, position = 1)
    private String inandoutCode;

    @ApiModelProperty(value = "通道名称", example = "出1", required = true, position = 2)
    private String inandoutName;

    @ApiModelProperty(value = "通道类型，1入口 2出口", example = "1", required = true, position = 3)
    private Integer inandoutType;

    @ApiModelProperty(value = "是否是主通道 1=是 0=否，默认为1", example = "1", required = true, position = 4)
    private Integer isMaster;

    @ApiModelProperty(value = "区域编号，预留字段，暂不支持多区域", example = "1", required = false, position = 5)
    private String regionCode;

    @ApiModelProperty(value = "是否收费 1=是 0=否", example = "1", required = false, position = 6)
    private Integer isFee;

    @ApiModelProperty(value = "是否允许临时车进出 0:不允许 1：允许，默认1", example = "1", required = false, position =7)
    private Integer isAllowTempcarrun;

    @ApiModelProperty(value = "是否允许无牌车扫码进出 0:不允许 1：允许，默认1", example = "1", required = false, position =8)
    private Integer isAllowNocardrun;

    @ApiModelProperty(value = "黄牌车是否允许进 0:不开启 1：开启，默认1", example = "1", required = false, position =9)
    private Integer isAllowYellowcarrun;

    @ApiModelProperty(value = "是否开启模糊识别 0:不开启 1：开启，默认0", example = "1", required = false, position =10)
    private Integer isOpenVaguetype;

    @ApiModelProperty(value = "模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位", example = "1", required = false, position =11)
    private Integer vaguetype;

    @ApiModelProperty(value = "是否允许新能源车辆进出 0：不允许 1：允许", example = "1", required = false, position =12)
    private Integer isAllowNewenergycarrun;

    @ApiModelProperty(value = "是否允许预约车进出0：不允许，1：允许", example = "1", required = false, position =13)
    private Integer isAllowVisitCar;

    @ApiModelProperty(value = "是否允月卡车车进出0：不允许，1：允许", example = "1", required = false, position =14)
    private Integer isAllowMonthCar;

    @ApiModelProperty(value = "是否允许过期月卡车进出0：不允许，1：允许", example = "1", required = false, position =15)
    private Integer isOverTimeMonth;

    @ApiModelProperty(value = "过期天数 isOverTimeMonth=1必填", example = "1", required = false, position=16)
    private Integer overTimeDay;

    @ApiModelProperty(value = "过期卡是否按月卡处理0：否，1：是 isOverTimeMonth=1必填", example = "1", required = false, position=17)
    private Integer overTimeMonthlyCard;

    @ApiModelProperty(value = "是否允许多位多车月卡车进出1=是 0=否，默认1", example = "1", required = false, position=18)
    private Integer isAllowAbcar;

    @ApiModelProperty(value = "是否允许黑名单车进出0：不允许，1：允许，默认0", example = "1", required = false, position=19)
    private Integer isAllowBackCar;

    @ApiModelProperty(value = "是否允许储值卡车进出0：不允许，1：允许，默认1", example = "1", required = false, position=20)
    private Integer isAllowStoredCar;

    @ApiModelProperty(value = "是否允许Vip车进出0：不允许，1：允许，默认1", example = "1", required = false, position=21)
    private Integer isAllowVipCar;

    @ApiModelProperty(value = "vip车类型，多个以逗号隔开", example = "1", required = false, position=22)
    private String vipCarTypeId;

    @ApiModelProperty(value = "设备信息", example = "", required = false, position=23)
    private List<ParkDevices> devices;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ParkDevices implements Serializable {

        @ApiModelProperty(value = "设备编号", example = "", required = false, position=1)
        private String deviceNo;

        @ApiModelProperty(value = "设备类型 0：超级盒子 1：摄像头 2:道闸 3:显示屏 4:语音对讲机", example = "1", required = false, position=2)
        private Integer type;

        @ApiModelProperty(value = "相机型号1：V82， 2：V83", example = "1", required = false, position=3)
        private Integer modelType;

        @ApiModelProperty(value = "相机序列号", example = "1", required = false, position=4)
        private String serialNumber;

        @ApiModelProperty(value = "设备IP", example = "1", required = false, position=5)
        private String ip;

        @ApiModelProperty(value = "设备端口", example = "3306", required = false, position=6)
        private String port;

        @ApiModelProperty(value = "通讯方式 1:4G 2:有线3:wifi 4:相机485透传", example = "1", required = false, position=7)
        private Integer callMethods;

        @ApiModelProperty(value = "设备状态，0初始1在线2离线3故障", example = "1", required = false, position=8)
        private Integer status;

        @ApiModelProperty(value = "串口地址", example = "1", required = false, position=9)
        private Integer serialaddr;

        @ApiModelProperty(value = "波特率（0：1200，1：2400，2：4800，3：9600，4：19200，5：38400，6：115200，默认2400）", example = "1", required = false, position=10)
        private Integer baudrate;

        @ApiModelProperty(value = "直播地址", example = "1", required = false, position=11)
        private String videoUrl;

        @ApiModelProperty(value = "第三方设备编码", example = "1", required = false, position=12)
        private String thirdCode;

        @ApiModelProperty(value = "是否主相机", example = "1", required = false, position=13)
        private Integer isMaster;


        @ApiModelProperty(value = "是否双摄像机", example = "1", required = false, position=14)
        private Integer isDualcamera;


        @ApiModelProperty(value = "备验证码-监控相机", example = "1", required = false, position=15)
        private String verCode;


        @ApiModelProperty(value = "端云相机协议版本号", example = "1", required = false, position=16)
        private String protocolVer;


        @ApiModelProperty(value = "端云相机协议类型，1：WS，2：阿里IOT", example = "1", required = false, position=17)
        private Integer protocolType;

        @ApiModelProperty(value = "产品型号", example = "1", required = false, position=18)
        private String productModel;


        @ApiModelProperty(value = "固件版本号", example = "1", required = false, position=19)
        private String firmwareVersion;


        @ApiModelProperty(value = "通讯协议是否自动切换 0:否  1：是 默认1", example = "1", required = false, position=20)
        private Integer isAutoswitchCheck;

        @ApiModelProperty(value = "语音对讲设备厂商类型 1：云翌  2：笛虎", example = "1", required = false, position=21)
        private Integer voicevendorType;


        @ApiModelProperty(value = "网络连接方式，1:无线，2:有线", example = "1", required = false, position=22)
        private Integer connectionMode;

        @ApiModelProperty(value = "无线网络运营商，1:移动，2:电信，3：联通，99：未知", example = "1", required = false, position=23)
        private Integer wirelessCarrier;

        @ApiModelProperty(value = "无线网络运营商，1:移动，2:电信，3：联通，99：未知", example = "1", required = false, position=23)
        private String network;

        @ApiModelProperty(value = " 是否连接语音屏显（0：否，1：是）", example = "1", required = false, position=24)
        private Integer isVoiceLed;

        @ApiModelProperty(value = " 是否连接道闸（0：否，1：是））", example = "1", required = false, position=25)
        private Integer isParkGate;
    }

}
