package com.icetech.partner.api.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-12-12 14:08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WuXiQuPayResultMsgResponse implements Serializable {

    /**
     * 车牌号
     */
    private String plateNo;

    /**
     * 车牌颜色
     */
    private Integer plateColor;

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 账单编号
     */
    private String recordId;

    /**
     * 账单id
     */
    private String billId;

    /**
     * 实付金额
     */
    private Integer actualPay;

    /**
     * 账单支付完成状态0：未完成 1：已完成
     */
    private Integer payStatus;

    /**
     * 第三方渠道返回的支付金额
     */
    private Integer transAmount;

    /**
     * 平台优惠金额
     */
    private Integer discountAmount;

    /**
     * 交易时间
     */
    private String dealTime;

    /**
     * 第三方渠道支付流水号
     */
    private String orderCode;

    /**
     * 支付方式
     */
    private Integer paidType;
}
