package com.icetech.partner.api.request.open.teld;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class TeldBaseRequest extends TeldBaseBean {
    /**
     * 运营商标识，组织机构代码或统一社会信用代码9-17位
     */
    protected String operatorID;
    /**
     * 参数内容
     */
    protected String data;
    /**
     * 时间戳，格式为yyyyMMddHHmmss
     */
    protected String timeStamp;
    /**
     * 自增序列，4位自增序列，取自时间戳，新秒重计
     */
    protected String seq;

    @Override
    public String buildSignContent() {
        return getOperatorID() + getData() + getTimeStamp() + getSeq();
    }
}
