package com.icetech.partner.api.request.open.teld;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
public class QueryListReqData implements Serializable {
    /**
     * <p>电站编号</p>
     * <p>充电运营商定义的电站唯一编码（停车场编号和电站编号必须填写一项）</p>
     * <p>必填: 否</p>
     * <p>长度: 20</p>
     */
    protected String StationID;
    /**
     * <p>停车场编号</p>
     * <p>停车场平台下的唯一编码（停车场编号和电站编号必须填写一项）</p>
     * <p>必填: 否</p>
     * <p>长度: 30</p>
     */
    protected String ParkID;
    /**
     * <p>停车票更新起始时间</p>
     * <p>格式“yyyy-MM-dd HH:mm:ss”查询时间范围</p>
     * <p>必填: 是</p>
     * <p>长度:  </p>
     */
    protected String StartTime;
    /**
     * <p>停车票更新结束时间</p>
     * <p>格式“yyyy-MM-dd HH:mm:ss”查询时间范围</p>
     * <p>必填: 是</p>
     * <p>长度:  </p>
     */
    protected String EndTime;
}
