package com.icetech.partner.api.request.open.rule;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * Description ChargeRuleListRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/15 17:50
 */
@Data
public class ChargeRuleListRequest implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    @ApiModelProperty(value = "分页查询页码（默认1,每页10条）", example = "1", position = 2)
    private Integer pageNum = 0;

    @ApiModelProperty(value = "分页查询单页数量（默认20 小于1000）", example = "20", position = 3)
    private Integer pageSize = 0;

    @ApiModelProperty(value = "计费规则名称", example = "test001", position = 4)
    private String billtypename;
}
