package com.icetech.partner.api.request.open.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description SaveChannelRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @Date 2022/7/14 09:45
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SaveChannelRequest implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号（系统自动生成）", example = "P100122", required = true, position = 1)
    private String parkCode;

    @ApiModelProperty(value = "通道编号，编辑时必传", example = "100122", position = 2)
    private String inandoutCode;

    @NotBlank(message = "通道名称不能为空")
    @ApiModelProperty(value = "通道名称", example = "出1", required = true, position = 3)
    private String inandoutName;

    @NotNull(message = "通道类型不能为空")
    @ApiModelProperty(value = "通道类型，1入口 2出口", example = "出1", required = true, position = 4)
    private Integer inandoutType;

    @NotNull(message = "是否是主通道不能为空")
    @ApiModelProperty(value = "是否是主通道 1=是 0=否，默认为1", example = "1", required = true, position = 5)
    private Integer isMaster;

    @ApiModelProperty(value = "区域编号", example = "11120", position = 6)
    private String regionCode;

    @ApiModelProperty(value = "是否收费 1=是 0=否", example = "1", position = 7)
    private Integer isCharge;

    @ApiModelProperty(value = "是否允许临时车进出 0:不允许 1：允许，默认1", example = "1", position = 8)
    private Integer isAllowTempcarrun;

    @ApiModelProperty(value = "是否允许无牌车扫码进出 0:不允许 1：允许，默认1", example = "1", position = 9)
    private Integer isAllowNocardrun;

    @ApiModelProperty(value = "黄牌车是否允许进 0:不开启 1：开启，默认1", example = "1", position = 10)
    private Integer isAllowYellowcarrun;

    @ApiModelProperty(value = "是否开启模糊识别 0:不开启 1：开启，默认0", example = "1", position = 11)
    private Integer isOpenVaguetype;

    @ApiModelProperty(value = "模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位", example = "1", position = 12)
    private Integer vaguetype;

    @ApiModelProperty(value = "是否允许新能源车辆进出 0：不允许 1：允许", example = "1", position = 13)
    private Integer isAllowNewenergycarrun;

    @ApiModelProperty(value = "是否允许预约车进出0：不允许，1：允许", example = "1", position = 14)
    private Integer isAllowVisitCar;

    @ApiModelProperty(value = "是否允月卡车车进出0：不允许，1：允许", example = "1", position = 15)
    private Integer isAllowMonthCar;

    @ApiModelProperty(value = "是否允许过期月卡车进出0：不允许，1：允许", example = "1", position = 16)
    private Integer isAllowOvertimeCar;

    @ApiModelProperty(value = "过期天数 isOverTimeMonth=1必填", example = "1", position = 17)
    private Integer overTimeDay;

    @ApiModelProperty(value = "过期卡是否按月卡处理0：否，1：是 isOverTimeMonth=1必填", example = "1", position = 18)
    private Integer overTimeMonthlyCard;

    @ApiModelProperty(value = "是否允许多位多车月卡车进出1=是 0=否，默认1", example = "1", position = 19)
    private Integer isAllowABcar;

    @ApiModelProperty(value = "是否允许黑名单车进出0：不允许，1：允许，默认0", example = "1", position = 20)
    private Integer isAllowBackCar;

    @ApiModelProperty(value = "是否允许储值卡车进出0：不允许，1：允许，默认1", example = "1", position = 21)
    private Integer isAllowStoredCar;

    @ApiModelProperty(value = "是否允许Vip车进出0：不允许，1：允许，默认1", example = "1", position = 22)
    private Integer isAllowVipCar;

    @ApiModelProperty(value = "vip车场类型，多个以逗号隔开", example = "", position = 23)
    private String vipCarType;
    
    @ApiModelProperty(value = "主识别相机", example = "", position = 24)
    private MainCamera mainCamera;

    @ApiModelProperty(value = "辅识别相机", example = "", position = 25)
    private SecoCamera secoCamera;

    @ApiModelProperty(value = "智能机器人", example = "", position = 26)
    private RobotDev robotDev;

    @ApiModelProperty(value = "语音对讲设备", example = "", position = 27)
    private VoiceDev voiceDev;

    @ApiModelProperty(value = "监控相机设备", example = "", position = 28)
    private MonitorDev monitorDev;
    
    @ApiModelProperty(value = "对讲缴费终端设备", example = "", position = 29)
    private IntercomPillarDev intercomPillarDev;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class MainCamera implements Serializable {
        @ApiModelProperty(value = "设备编号（编辑时必填）", example = "111", position = 1)
        private String deviceNo;

        @NotBlank(message = "主相机ip不能为空")
        @ApiModelProperty(value = "主相机ip", example = "192.168.0.1", required = true, position = 2)
        private String ip;

        @NotNull(message = "通讯方式不能为空")
        @ApiModelProperty(value = "通讯方式（1:4G 2:有线）", example = "1", required = true, position = 3)
        private Integer linetype;

        @NotBlank(message = "主相机序列号不能为空")
        @ApiModelProperty(value = "主相机序列号", example = "1548d1215", required = true, position = 4)
        private String serialNumber;

        @NotNull(message = "是否连接语音屏显不能为空")
        @ApiModelProperty(value = "是否连接语音屏显（0：否，1：是）", example = "1", required = true, position = 5)
        private Integer isVoiceLed;

        @NotNull(message = "是否连接道闸不能为空")
        @ApiModelProperty(value = "是否连接道闸（0：否，1：是）", example = "1", required = true, position = 6)
        private Integer isParkGate;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class SecoCamera implements Serializable {

        @ApiModelProperty(value = "设备编号（编辑时必填）", example = "111", position = 1)
        private String deviceNo;

        @NotBlank(message = "辅相机ip不能为空")
        @ApiModelProperty(value = "辅相机ip", example = "192.168.0.1", required = true, position = 2)
        private String ip;

        @NotNull(message = "通讯方式不能为空")
        @ApiModelProperty(value = "通讯方式（1:4G 2:有线）", example = "1", required = true, position = 3)
        private Integer linetype;

        @NotBlank(message = "主相机序列号不能为空")
        @ApiModelProperty(value = "主相机序列号", example = "1548d1215", required = true, position = 4)
        private String serialNumber;

        @NotNull(message = "是否连接语音屏显不能为空")
        @ApiModelProperty(value = "是否连接语音屏显（0：否，1：是）", example = "1", required = true, position = 5)
        private Integer isVoiceLed;

        @NotNull(message = "是否连接道闸不能为空")
        @ApiModelProperty(value = "是否连接道闸（0：否，1：是）", example = "1", required = true, position = 6)
        private Integer isParkGate;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class RobotDev implements Serializable {

        @ApiModelProperty(value = "设备编号（编辑时必填）", example = "111", position = 1)
        private String deviceNo;

        @NotBlank(message = "机器人ip不能为空")
        @ApiModelProperty(value = "机器人ip", example = "192.168.0.1", required = true, position = 2)
        private String ip;

        @NotNull(message = "机器人端口号不能为空")
        @ApiModelProperty(value = "机器人端口号", example = "3306", required = true, position = 3)
        private Integer port;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class VoiceDev implements Serializable {

        @ApiModelProperty(value = "设备编号（编辑时必填）", example = "111", position = 1)
        private String deviceNo;

        @NotBlank(message = "监控相机序列号不能为空")
        @ApiModelProperty(value = "监控相机序列号", example = "1k151211w1516", required = true, position = 2)
        private String serialNumber;

    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class MonitorDev implements Serializable {

        @ApiModelProperty(value = "设备编号（编辑时必填）", example = "111", position = 1)
        private String deviceNo;

        @NotBlank(message = "监控相机序列号不能为空")
        @ApiModelProperty(value = "监控相机序列号", example = "1k151211w1516", required = true, position = 2)
        private String serialNumber;

        @NotBlank(message = "验证码不能为空")
        @ApiModelProperty(value = "验证码", example = "123456", required = true, position = 3)
        private String verCode;

    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class IntercomPillarDev implements Serializable {

        @ApiModelProperty(value = "设备编号（编辑时必填）", example = "111", position = 1)
        private String deviceNo;

        @NotBlank(message = "监控相机序列号不能为空")
        @ApiModelProperty(value = "监控相机序列号", example = "1k151211w1516", required = true, position = 2)
        private String serialNumber;

        /** 通讯方式 1:无线 2:有线3:wifi 4:相机485透传 */
        @NotBlank(message = "通讯方式不能为空")
        @ApiModelProperty(value = "通讯方式", example = "1", required = true, position = 3)
        protected Integer callMethods;

        @ApiModelProperty(value = "ip", example = "", position = 4)
        private String ip;

    }


}
