package com.icetech.partner.api.request.open.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * Description SaveParkRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @Date 2022/7/14 09:45
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ParkDeviceListRequest implements Serializable {

    @ApiModelProperty(value = "停车场编号", example = "P100122", required = false, position = 1)
    private String parkCode;

    @ApiModelProperty(value = "设备状态 0未连接，1在线，2离线", example = "0", required = false, position = 2)
    private Integer deviceStatus;

    @ApiModelProperty(value = "当前加载的页码 默认加载第一页", example = "0", required = false, position = 3)
    private Integer pageNo = 0;

    @ApiModelProperty(value = "每页显示的记录数", example = "10", required = false, position = 4)
    private Integer pageSize = 0;

}
