package com.icetech.partner.api.request.open.base;

import com.icetech.partner.api.response.base.RegionListResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description EditParkRegionRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/18 11:32
 */
@Data
public class EditParkRegionRequest implements Serializable {

    @NotBlank(message = "分区编号不能为空")
    @ApiModelProperty(value = "分区编号（长度6-32位，全平台唯一）", required = true, example = "100003", position = 1)
    private String regionCode;

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P1000001", position = 2)
    private String parkCode;

    @NotBlank(message = "区域名称不能为空")
    @ApiModelProperty(value = "区域名称", required = true, example = "北区域", position = 3)
    private String regionName;

    @ApiModelProperty(value = "区域泊位总数",  example = "100", position = 4)
    private Integer regionPark;

    @ApiModelProperty(value = "计费规则编号（从计费规则列表接口中获取或者不传此参数，会使用车场默认计费规则）",  example = "100", position = 5)
    private String billtypecode;

    @NotNull
    @ApiModelProperty(value = "是否有子区域 1：有 2：无", required = true, example = "1", position = 6)
    private Integer hasInner;

    @ApiModelProperty(value = "子区域数据 hasInner==1是此参数必填", required = false, example = "1", position = 7)
    private SonData sonData;

    @Data
    public static class SonData implements Serializable {

        @NotBlank(message = "子区域名称不能为空")
        @ApiModelProperty(value = "子区域名称", required = true, example = "北1区域", position = 1)
        private String regionName;

        @NotBlank(message = "子分区编号不能为空")
        @ApiModelProperty(value = "子分区编号（长度6-32位，全平台唯一）", required = true, example = "1222211", position = 2)
        private String regionCode;

        @ApiModelProperty(value = "子区域泊位总数", required = true, example = "3", position = 3)
        private Integer regionPark;

        @ApiModelProperty(value = "子区域计费规则编号（从计费规则列表接口中获取或者不传此参数，会使用车场默认计费规则）", required = true, example = "3", position = 4)
        private String billtypecode;
    }
}
