package com.icetech.partner.api.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wanggang
 * @create 2021-07-22 19:33
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class QrcodeUrlResponse implements Serializable {

    @ApiModelProperty(value = "场内支付二维码URL", required = true, example = "http://api.ice.com", position = 1)
    private String inparkUrl;

    @ApiModelProperty(value = "通道码集合", required = true, example = "", position = 2)
    private List<ChannelUrls> channelUrls = new ArrayList<>();
}
