package com.icetech.partner.api.request.open;


import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * @author zhangpengzhan
 * @date 2021/6/7 17:10
 */
@Data
public class ParkInfoCheckRequest {

    @NotNull
    @NotBlank(message = "停车场名称不能为空")
    @ApiModelProperty(value = "停车场名称", required = true, example = "停车场1", position = 1)
    private String parkName;

    private String parkCode;
    /**
     * 总车位数
     */
    @NotNull
    private Integer totalNum;
    @NotNull
    private Integer dataCollection;

    /**
     * 车场所属城市
     */
    @NotNull
    private Integer cityId;
    /**
     * 所属区域
     */
    @NotNull
    private Integer districtId;

    /**
     * 机构id
     *
     */
    private Integer institutionId;
    @NotNull
    private Integer provinceId;

    /**
     * 车场地址
     */
    private String address;
    private String key;
    /**
     * 车场经度
     */
    private String lat;
    /**
     * 车场纬度
     */
    private String lng;
    /**
     *电话
     */
    private String telphone;
    /**
     *出口数量
     */
    private Integer totalExit;
    /**
     *入口数量
     */
    private Integer totalEnter;
    /**
     *省份
     */
    private String provinceName;
    /**
     *省份
     */
    private String provinceCode;
    /**
     *城市
     */
    private String cityName;
    /**
     *城市
     */
    private String cityCode;
    /**
     *地区
     */
    private String  districtName;
    /**
     *地区
     */
    private String  districtCode;
    /**
     *状态
     */
    private String status;
    /**
     *所属机构名称
     */
    private String institutionName;
    /**
     *停车场属性
     */
    private Integer parkProperty = 5;
    /**
     * 是否存在场中场(0否，1是默认0)
     */
    private int isInterior;
    /**
     * 场中场切换免费时长 分钟
     */
    private Integer switchFeeTime;

    private Integer totalFixedspaces;
    private int parkType;
    private Integer parkClientType;
    private Integer assetType;
    private Integer cooperateType;
    private Date createTime;
    private Date updateTime;
    private String adder;
    private String updateUser;
    private String parkBusinessLicense;
    private String parkImgs;
    private String phone;
    private Integer freeSpace;
    private Integer enterSize;
    private Integer exitSize;
    private Long id;
}
