package com.icetech.partner.api.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Getter
@Setter
@ToString
public class BlacklistSaveRequest implements Serializable {
    @NotBlank(message = "车场编码不能为空")
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "P100001", position = 1)
    private String parkCode;

    /** 车牌号, 多个以英文,分割 */
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号, 多个以英文,分割", required = true, example = "京JS7680", position = 2)
    private String plateNum;

    /** 姓名 */
    @ApiModelProperty(value = "姓名", example = "张三", position = 3)
    private String owner;

    /** 车型(2大型车、1小型车，默认1) */
    @ApiModelProperty(value = "车型(2大型车、1小型车，默认1)", example = "1", position = 4)
    private Integer carType;

    /** 原因 */
    @ApiModelProperty(value = "原因", example = "重复入场", position = 5)
    private String reason;
}
