package com.icetech.partner.api.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Getter
@Setter
@ToString
public class BlacklistDeleteRequest implements Serializable {
    @NotBlank(message = "车场编码不能为空")
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "P100001", position = 1)
    private String parkCode;

    /** 车牌号, 多个以英文,分割 */
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号, 多个以英文,分割", required = true, example = "京JS7680", position = 2)
    private String plateNum;

}
