package com.icetech.partner.api.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 云纵拉取费用请求
 */
@Data
public class YzPayNotifyRequest implements Serializable {

    /**
     * 车牌号
     */
    private String plate_no;
    /**
     * 交易状态 SUCCESS：成功，FAIL：失败
     */
    private String trade_status;
    /**
     * 支付类型 ALIPAY，WECHAT
     */
    private String pay_type;
    /**
     * 商户订单号(对应系统中的orderNum)
     */
    private String out_order_id;
    /**
     * yz交易流水号
     */
    private String trade_no;
    /**
     * 订单总金额 分
     */
    private String total_amount = "0";
    /**
     * 订单优惠金额，有券核销时才返回，单位为分
     */
    private String discount_amount = "0";
    /**
     * 应结算金额。 应结算金额=订单总金额-优惠金额。支付成功时返回，无优惠券抵扣时，等于total_amount
     */
    private String settlement_amount = "0";
    /**
     * 用户支付完成时间，格式：yyyy-MM-dd HH:mm:ss
     */
    private String pay_time;
}
