package com.icetech.partner.api.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 云纵拉取费用请求
 */
@Data
public class TongChengPayNotifyRequest implements Serializable {

    /**
     * 车场编号 20230710625537
     */
    private String parkNo;
    /**
     * 应用编号
     */
    private String appid;
    /**
     * 车牌号
     */
    private String plate;
    /**
     * 车牌颜色 0: '未知', 1: '蓝色', 2: '黄色', 3: '白色', 4: '黑色', 5: '绿色',
     */
    private Integer plate_color;
    /**
     * 支付金额
     */
    private String payMoney;
    /**
     * 道口费用查询为车道 号 预支付查询值为0
     */
    private Integer chNo;
    /**
     * 签名 所有非空参数字典排序后&secret 取MD5
     */
    private String sign;
    /**
     * 请求时间戳 秒
     */
    private Integer ts;
    /**
     * 支付临时订单ID
     */
    private String temp_order_id;
    /**
     * 停车订单ID
     */
    private String order_id;
    /**
     * 支付类型 1 微信，2 支付宝 3 云闪付
     */
    private String payType;
    /**
     * 支付时间戳 毫秒
     */
    private String payTime;
    /**
     * 交易流水号
     */
    private String trade_no;


}
