package com.icetech.partner.api.request;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@Setter
@Getter
@ToString
public class ThirdAutoPayRequest implements Serializable {
    @NotNull
    private String orderNum;
    @NotNull
    private String plateNum;
    @NotNull
    private Long enterTime;
    @NotNull
    private String totalPrice;
    private String paidPrice;
    @NotNull
    private String discountPrice;
    @NotNull
    private Integer parkTime;
    @NotNull
    private String unpayPrice;
    private Integer unpayPriceFen;
    @NotNull
    private Long payTime;
    @NotNull
    private String parkCode;
    @NotNull
    private Long parkId;
    @NotNull
    private Long channelId;
    private String channelCode;
    private String channelName;
    private Integer type;
    /**
     * 出口车牌识别的颜色
     */
    private String plateColor;

    /**
     * 本次停车总金额，从车辆入场至当前时间计费的总费用
     */
    private String totalAmount;

}
