package com.icetech.partner.api;

import java.util.Map;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.partner.domain.request.wx.PushEnterMessage4WX;
import com.icetech.partner.domain.request.wx.PushExitMessage4WX;
import com.icetech.partner.domain.response.wx.WxOcrResponse;

public interface WxService {
    /**
     * 获取微信token
     * @param appid
     * @return
     */
    ObjectResponse<Map<String, String>> getToken(String appid);

    /**
     * 获取微信 js api ticket
     * @param appid
     * @return
     */
    ObjectResponse<Map<String, String>> getTicket(String appid);

    /**
     * 获取openId
     * @param appid
     * @param authCode
     * @return
     */
    ObjectResponse<String> getOpenId(String appid,String authCode);

    /**
     * 微信入场消息推送
     * @param pushEnterMessage4WX
     * @return
     */
    ObjectResponse enterMessage(PushEnterMessage4WX pushEnterMessage4WX);

    /**
     * 微信离场消息推送
     * @param pushExitMessage4WX
     * @return
     */
    ObjectResponse exitMessage(PushExitMessage4WX pushExitMessage4WX);

    /**
     * ocr识别接口
     * @param bytes
     * @param type 1= 身份证 2= 许可证
     * @return
     */
    ObjectResponse<WxOcrResponse> ocrImage(byte[] bytes, String filePath, String fileName, Integer type);

    /**
     * ocr识别
     * @param url 图片url地址
     * @param type 类型 1= 身份证 2= 许可证 3=银行卡
     * @return
     */
    ObjectResponse<WxOcrResponse> ocrImage(String ossPath, Integer type);

}
