package com.icetech.partner.api;

import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.pnc.AutopayRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.partner.api.request.ThirdAutoPayRequest;

import java.util.Map;

/**
 * 第三方代扣
 * @author zhaoys
 */
public interface ThirdAutoPayService {
    /**
     * 第三方代扣
     * @deprecated 废弃, 使用{@link ThirdAutoPayService#autoPay(ThirdAutoPayRequest, ThirdInfo)}
     * @return
     */
    @Deprecated
    ObjectResponse autoPay(AutopayRequest autopayRequest, Long parkId);

    /**
     *
     * @param autoPayRequest 参数
     * @param thirdInfo 三方信息
     * @return 响应
     */
    ObjectResponse<Object> autoPay(ThirdAutoPayRequest autoPayRequest, ThirdInfo thirdInfo);

    /**
     * 取消无感支付
     * @param autoPayRequest 参数
     * @param thirdInfo 三方信息
     * @return 响应
     */
    ObjectResponse<Object> cancelAutoPay(ThirdAutoPayRequest autoPayRequest, ThirdInfo thirdInfo);

    /**
     * 缴费结果通知
     * @param paraMap 参数
     * @return 响应
     */
    String autoPayResultNotify(Map<String, Object> paraMap, String pid);

    /**
     * 上海代扣
     * @param carExitRequest
     * @param queryOrderFeeResponse
     * @return
     */
    @Deprecated
    ObjectResponse<Boolean> autoPayShanghaiCloudPayMent(CarExitRequest carExitRequest, QueryOrderFeeResponse queryOrderFeeResponse);

    @Deprecated
    ObjectResponse downReduces(QueryOrderFeeRequest queryOrderFeeRequest, Map<String, Object> stringObjectMap);

    /**
     * 优惠拉取
     * @param queryOrderFeeRequest
     * @return
     */
    ObjectResponse downReduces(QueryOrderFeeRequest queryOrderFeeRequest);

    /**
     * 定制青岛领取优惠
     * @param orderNum
     * @param channelId
     * @param mobile
     * @return
     */
    ObjectResponse getCustomDiscount(String orderNum,String channelId,String mobile);

}
