package com.icetech.partner.api;


import com.icetech.open.domain.request.shijiazhuang.ShiJiaZhuangJiaoGuanBlacklistDTO;
import com.icetech.open.domain.request.shijiazhuang.ShiJiaZhuangJiaoGuanNotifyDTO;
import com.icetech.open.domain.request.shijiazhuang.ShiJiaZhuangJiaoGuanReserveDTO;
import com.icetech.open.domain.response.shijiazhuangjiaoguan.ShiJiaZhuangJiaoGuanCarInfoResponse;
import com.icetech.open.domain.response.shijiazhuangjiaoguan.ShiJiaZhuangJiaoGuanNotifyResponse;
import com.icetech.open.domain.response.shijiazhuangjiaoguan.ShiJiaZhuangJiaoGuanParkReserveResponse;
import com.icetech.open.domain.response.shijiazhuangjiaoguan.ShiJiaZhuangJiaoGuanParkSpaceResponse;
import com.icetech.open.domain.response.shijiazhuangjiaoguan.ShiJiaZhuangJiaoGuanQueryFeeResponse;

/**
 * @author wanggang
 * @create 2024-07-03 15:45
 */
public interface IShiJiaZhuangJiaoGuanService {

    /**
     * 拉费
     *
     * @param mcid
     * @param nodeId
     * @return
     */
    ShiJiaZhuangJiaoGuanQueryFeeResponse getOrderNoPay(String mcid, String nodeId);

    /**
     * 获取车牌信息
     *
     * @param mcid
     * @param lpnumber
     * @return
     */
    ShiJiaZhuangJiaoGuanCarInfoResponse getCarInfo(String mcid, String lpnumber);

    /**
     * 获取停车位信息
     *
     * @param mcid
     * @return
     */
    ShiJiaZhuangJiaoGuanParkSpaceResponse getParkSpace(String mcid);

    /**
     * 支付通知
     *
     * @param notifyDTO
     * @return
     */
    ShiJiaZhuangJiaoGuanNotifyResponse notifyPay(ShiJiaZhuangJiaoGuanNotifyDTO notifyDTO);

    /**
     * 添加预约车辆
     *
     * @param reserveDTO
     * @return
     */
    ShiJiaZhuangJiaoGuanParkReserveResponse addReserve(ShiJiaZhuangJiaoGuanReserveDTO reserveDTO);

    /**
     * 修改总车位
     *
     * @param mcid
     * @param totalSpace
     * @return
     */
    ShiJiaZhuangJiaoGuanNotifyResponse spaceUpdate(String mcid, Integer totalSpace);

    /**
     * 黑白名单
     *
     * @param blacklistDTO
     * @return
     */
    ShiJiaZhuangJiaoGuanNotifyResponse blackList(ShiJiaZhuangJiaoGuanBlacklistDTO blacklistDTO);
}
