package com.icetech.partner.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.open.domain.response.GaoDeAddressResponse;
import com.icetech.open.domain.response.GaoDeLocationResponse;
import lombok.Getter;

import java.util.List;

public interface IMapService {
    /**
     * 根据经纬度获取
     * @param location 经纬度
     * @return
     */
    ObjectResponse<GaoDeAddressResponse> getAddress(String location);

    /**
     * 根据城市和关键字获取位置提示
     * @param cityCode 城市编码
     * @param key 搜索内容
     * @return
     */
    ObjectResponse<List<GaoDeLocationResponse>> getLocationTips(String cityCode,String key);

}
