package com.icetech.open.domain.response.wuxi;

import com.icetech.common.exception.ResponseBodyException;
import lombok.Data;

/**
 * 无锡智慧停车通用响应数据结构
 *
 * @author FGD
 */
@Data
public class WuXiResponse {
    /**
     * 是否成功。1000：成功，其他：失败
     */
    protected String code;
    /**
     * 失败原因描述
     */
    protected String msg;
    /**
     * 具体返回数据
     */
    protected String data;

    /**
     * 获取成功数据
     *
     * @return 成功数据
     * @throws ResponseBodyException Body错误信息
     */
    public String getSuccessData() {
        if (CODE_SUCCESS.equals(code)) {
            return data;
        }

        throw new ResponseBodyException(String.valueOf(code), msg);
    }

    /**
     * 成功
     */
    public static final String CODE_SUCCESS = "1000";
    /**
     * TOKEN失效
     */
    public static final String CODE_TOKEN_EXPIRE = "20004";
}
