package com.icetech.open.domain.response.sms;

import com.icetech.open.domain.BaseDomain;
import com.icetech.open.domain.enumeration.SmsResponseCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * open 模块响应
 * @author wangzw
 */
@Getter
@Setter
public class SmsResponse extends BaseDomain {
    /**
     * 返回码
     */
    private String code;
    /**
     * 短信Id
     */
    private List<SmsResponseInfo> message;

    public static boolean isSuccess(SmsResponse response) {
        return response != null &&
                (SmsResponseCode.ERROR_00.getCode().equals(response.getCode())
                        || SmsResponseCode.ERROR_01.getCode().equals(response.getCode())
                        || SmsResponseCode.ERROR_03.getCode().equals(response.getCode()));
    }
}
