package com.icetech.open.domain.response.shijiazhuangjiaoguan;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-11-25 15:22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ShiJiaZhuangJiaoGuanQueryFeeResponse implements Serializable {

    /**
     * 响应码:1成功;0失败;
     */
    private Integer state;

    /**
     * 响应描述
     */
    private String errMsg;

    /**
     * 费用信息
     */
    private ParkOrderNoPayMessage data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ParkOrderNoPayMessage implements Serializable {

        /**
         *  入场时间
         */
        private Long inTime;

        /**
         * 车牌号
         */
        private String lpnumber;

        /**
         * 车场编号
         */
        private String mcid;

        /**
         * 应付金额(分)
         */
        private Integer money;

        /**
         * 出口通道编号
         */
        private String nodeId;

        /**
         * 停车时长(分)
         */
        private Long timeLong;

        /**
         * 订单号
         */
        private String transId;
    }
}
