package com.icetech.open.domain.response.shijiazhuangjiaoguan;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-11-25 15:22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ShiJiaZhuangJiaoGuanParkSpaceResponse implements Serializable {

    /**
     * 响应码:1成功;0失败;
     */
    private Integer state;

    /**
     * 响应描述
     */
    private String errMsg;

    /**
     * 费用信息
     */
    private Space data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Space implements Serializable {
        /**
         * 停车区域名称 Eg：长安区，裕华区
         */
        private String areaName;
        /**
         * 总车位数
         */
        private Integer totalSpace;

        /**
         * 剩余车位数
         */
        private Integer remainSpace;
    }
}
