package com.icetech.open.domain.response.shijiazhuangjiaoguan;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-11-25 15:22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ShiJiaZhuangJiaoGuanCarInfoResponse implements Serializable {

    /**
     * 响应码:1成功;0失败;
     */
    private Integer state;

    /**
     * 响应描述
     */
    private String errMsg;

    /**
     * 费用信息
     */
    private CarInfo data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class CarInfo implements Serializable {

        /**
         *  车辆停车状态:0未查询到车辆;1已进场; 2已已出场
         */
        private Integer parkStatus;

        /**
         * 入场时间:10 位时间戳
         */
        private Long inTime;

        /**
         * 出场时间:10位时间戳
         */
        private Long outTime;

        /**
         * 应付金额(分)
         */
        private Integer money;

        /**
         * 出口通道编号
         */
        private String nodeId;

        /**
         * 停车时长(分)
         */
        private Long timeLong;

        /**
         * 订单号
         */
        private String orderCode;
    }
}
