package com.icetech.open.domain.response.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单查询响应
 * @author wangzhiwei
 */
@Data
@AllArgsConstructor
@Builder
@NoArgsConstructor
public class QueryPayResultResponse implements Serializable {

    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    @ApiModelProperty(value = "停车场名称", required = true, example = "北辰停车场", position = 2)
    private String parkName;

    @ApiModelProperty(value = "订单号，确保订单号在此车场内的唯一性", required = true, example = "1000000220020", position = 3)
    private String orderNum;

    @ApiModelProperty(value = "交易流水号", required = true, example = "3131313", position = 4)
    private String tradeNo;

    @ApiModelProperty(value = "支付时间（unix时间戳 10位）", required = true, example = "1657614044", position = 5)
    private Long payTime;

    @ApiModelProperty(value = "总支付金额", required = true, example = "100.00", position = 6)
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "已支付金额", required = true, example = "10.00", position = 7)
    private BigDecimal paidPrice;

    @ApiModelProperty(value = "优惠金额", example = "10.00", position = 8)
    private BigDecimal discountPrice;

    @ApiModelProperty(value = "支付渠道，详情查看数据定义部分", required = true, example = "1", position = 9)
    private Integer payChannel;

    @ApiModelProperty(value = "支付方式，详情查看数据定义部分", required = true, example = "2", position = 10)
    private Integer payWay;

    @ApiModelProperty(value = "缴费的通道编号，不传时为场内支付", example = "C10000", position = 11)
    private String channelCode;

}
