package com.icetech.open.domain.response.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@Setter
@Getter
@ToString
public class QueryFeeResponse implements Serializable {

    @ApiModelProperty(value = "订单号", example = "D1111", required = true, position = 1)
    private String orderNum;

    @ApiModelProperty(value = "车场名称", example = "P100000", required = true, position = 15)
    private String parkName;

    @ApiModelProperty(value = "车辆入场时间[unix时间戳]", example = "1657614044", required = true, position = 2)
    private Long enterTime;

    @ApiModelProperty(value = "车牌号 / 无牌车没有车牌传递临时车牌号", example = "京A88888", required = true, position = 3)
    private String plateNum;

    @ApiModelProperty(value = "交易流水号", example = "1212122", required = true, position = 4)
    private String tradeNo;

    @ApiModelProperty(value = "车型", example = "1", required = true, position = 5)
    private Integer carType;

    @ApiModelProperty(value = "总应收 本车辆从入场到当前时刻的总费用", example = "10.00", required = true, position = 6)
    private Double totalPrice;

    @ApiModelProperty(value = "实收 (已经缴费金额)", example = "10.00", required = true, position = 7)
    private Double paidPrice;

    @ApiModelProperty(value = "总优惠", example = "0.00", required = true, position = 8)
    private Double discountPrice;

    @ApiModelProperty(value = "需支付金额", example = "10.00", required = true, position = 9)
    private Double needPayPrice;

    @ApiModelProperty(value = "停车时长（秒）", example = "360", required = true, position = 10)
    private Integer parkTime;

    @ApiModelProperty(value = "第三方抵扣金额总和", example = "0", position = 12)
    private Double outDiscAmount;

    @ApiModelProperty(value = "停车云平台抵扣金额总和", example = "0", position = 13)
    private Double inDiscAmount;

    @ApiModelProperty(value = "交费后预留免费时长，单位分钟", example = "10", position = 14)
    private Integer freeAfterPay;
}
