package com.icetech.open.domain.response.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2021-07-22 16:26
 */
@Data
@AllArgsConstructor
@Builder
@NoArgsConstructor
public class QueryDiscountRecordResponse implements Serializable {

    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    @ApiModelProperty(value = "停车场名称", required = true, example = "北辰停车场", position = 2)
    private String parkName;

    @ApiModelProperty(value = "订单号，确保订单号在此车场内的唯一性", required = true, example = "1000000220020", position = 3)
    private String orderNum;

    @ApiModelProperty(value = "优惠券名称", required = true, example = "满10减1", position = 4)
    private String discountName;

    @ApiModelProperty(value = "优惠券编号", required = true, example = "Y000001", position = 5)
    private String discountNo;

    @ApiModelProperty(value = "优惠内容", required = true, example = "100", position = 6)
    private String amount;

    @ApiModelProperty(value = "状态(0未使用1已使用默认0)", required = true, example = "0", position = 7)
    private Integer status;

    @ApiModelProperty(value = "优惠类型1全免2减免时间3减免金额4折扣", required = true, example = "1", position = 8)
    private Integer type;
}
