package com.icetech.open.domain.response.open;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class BaseDataResponse implements Serializable {
    private String parkName;
    private Integer entranceNum;
    private Integer exitNum;
    private String provinceName;
    private String city;
    private String region;
    private String address;
    private Integer parkingNum;
    /**
     * 通道信息
     */
    private List<ChannelData> channelData;

    @Data
    public static class ChannelData implements Serializable {
        private String channelCode;
        private String channelName;
        private Integer gateType;
        private Integer tempCarRun;
        private Integer noCardRun;
        private Integer yellowCarRun;
        private Integer qrcodeType;
        private Integer vagueType;
        private Integer deviceNum;
        private List<DeviceData> deviceData;
    }

    /**
     * 设备信息
     */
    @Data
    public static class DeviceData implements Serializable {
        private String deviceCode;
        private Integer deviceType;
        private Integer dualCamera;
        private Integer masterCamera;
        private String serialNumber;
        private String ip;
        private String port;
        private Integer callMethods;
        private String videoUrl;

    }
}
