package com.icetech.open.domain.response.fenmiao;

import lombok.Data;

import java.io.Serializable;
@Data
public class ParkingResponse implements Serializable {
    /**
     *每个场库的唯一编号(第 三方云分配)
     */
    private String parking_id;
    /**
     *车牌号
     */
    private String plate_num;
    /**
     *入场时间(yyyy-MM-dd HH:mm:ss)
     */
    private String in_time;
    /**
     *查询费用时间(yyyy-MM-dd HH:mm:ss)
     */
    private String query_time;
    /**
     *车牌颜色(例如:蓝色)
     */
    private String car_color;
    /**
     *车牌类型（例如:92 式民用车）
     */
    private String car_type;
    /**
     *总停车时长(单位: 分钟)
     */
    private Integer stop_time_total;
    /**
     *本次应收金额
     */
    private Double pay_charge;
    /**
     *入场图片名(url 或 Base64)
     */
    private String in_image;

    private String order_no;

}
