package com.icetech.open.domain.response.danyang;

import com.icetech.common.exception.ResponseBodyException;
import lombok.Data;

/**
 * 响应消息
 *
 * @param <T> 返回数据
 * @author FGD
 */
@Data
public class DanYangResponse<T> {
    /**
     * 响应代码（0：正常,1:错误）
     *
     * @see DanYangResponse#code
     */
    @Deprecated
    protected Integer resCode;
    /**
     * 响应消息(错误消息)
     *
     * @see DanYangResponse#message
     */
    @Deprecated
    protected String resMsg;
    /**
     * 响应代码（0：正常,1:错误）
     */
    protected Integer code;
    /**
     * 响应代码（0：正常,1:错误）
     */
    protected String message;
    /**
     * 数据体
     */
    protected T data;

    /**
     * 获取成功数据
     *
     * @return 成功数据
     * @throws ResponseBodyException Body错误信息
     */
    public T getSuccessData() {
        if (code != null && code == 0) {
            return data;
        }

        throw new ResponseBodyException(String.valueOf(code), message);
    }
}
