package com.icetech.open.domain.request.xinnengyuan;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-07-02 13:54
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class XinNengYuanFeeRequest implements Serializable {

    /**
     * 订单号(充电桩订单号),
     * 建议车场保证唯一，不允许为空
     */
    private String orderNo;

    /**
     * 车位号,停放位置  没有的请传空（此字段即使为空，签名时仍需包含在内）
     */
    private String spaceNo;

    /**
     * 车牌号(全车牌)不允许为空
     */
    private String plateNo;

    /**
     * 开始时间 不允许为空yyyy-MM-dd HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间 不允许为空yyyy-MM-dd HH:mm:ss
     */
    private String endTime;

    /**
     * 电站ID
     */
    private String stationId;

    /**
     * 设备ID
     */
    private String deviceId;

    /**
     * 设备编码
     */
    private String gunCode;

    /**
     * 充电量
     * 单位：度，小数点后2位  没有的请传空
     */
    private String power;

    /**
     * 电费
     * 单位：元  没有的请传空，支持两位小数
     */
    private String elecMoney;

    /**
     * 服务费/附加费
     * 单位：元  没有的请传空，支持两位小数
     */
    private String seviceMoney;

    /**
     * 总费用
     * 单位：元，没有的请传空，支持两位小数
     */
    private String totalMoney;

    /**
     * 设备名称
     */
    private String deviceName;

    /**
     * 电站名称
     */
    private String stationName;

    /**
     * 第三方账号（道闸停车方提供），新能源系统配置停车场账号，用于停车场系统识别
     */
    private String portName;

    /**
     * 停车场ID（道闸停车方提供），新能源系统配置停车场道闸ID，用于停车场系统识别
     */
    private String parkId;

    /**
     * 签名
     */
    private String sign;
}
