package com.icetech.open.domain.request.shijiazhuang;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-11-25 15:12
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ShiJiaZhuangJiaoGuanReserveDTO implements Serializable {

    /**
     * 车场编号
     */
    private String mcid;

    /**
     * 预约id;按id更新预约状态,不传代表新增预约名单
     */
    private String reserveId;

    /**
     * 预约开始时间;非更新时必填:10位时间戳
     */
    private Long startTime;

    /**
     * 预约结束时间;非更新时必填:10位时间戳
     */
    private Long endtime;

    /**
     * 状态:非更新时必填:1预约;2 取消预约
     */
    private Integer status;

    /**
     * 车牌号
     */
    private String lpnumber;

}
