package com.icetech.open.domain.request.platform;

import lombok.Data;

import java.util.List;

/**
 * 车场上报交警平台请求
 * @auto wangzw
 */
@Data
public class TPParkReportRequest {
    /**
     * 平台分配
     */
    private String CSID;
    /**
     * 报文版本
     */
    private String MSGVER;
    /**
     *服务商系统记录流水号 取随机数
     */
    private String CSPTLS;
    /**
     * psnupload
     */
    private String JYLX  ;
    /**
     *yyyy-MM-dd HH:mm:ss 请求时间
     */
    private String QQSJ;
    /**
     *停车场 ID
     */
    private String TCCID;
    /**
     *停车场名称
     */
    private String TCCMC;
    /**
     *经纬度地图标准
     */
    private String JWDBZ;
    /**
     *
     */
    private String TCCJD;
    /**
     *
     */
    private String TCCWD;
    /**
     *停车场注册总车位数
     */
    private String TCCCWS;
    /**
     *可容纳总车位数
     */
    private String  KRNCWS;
    /**
     *服务商停车场管理系统内更新本条记录 的时间
     */
    private String GXSJ;
    /**
     *停车场详细地址
     */
    private String XXDZ;
    /**
     *
     */
    private List<String> TPIDS;
    /**
     * 1 统一上传华为云
     */
    private String TPCSCC;
    /**
     * 进出口详细信息
     */
    private List<TPParkReportRequest.TPEnterOrExitInfo> JCKXX;
    /**
     * 报文通讯 mac
     */
    private String MAC;
    @Data
    public static class TPEnterOrExitInfo{

        /**
         *进出口编号
         */
        private String JCKBH;
        /**
         *进出口名称
         */
        private String JCKMC;
        /**
         * 0-百度； 1-高德； 2-其它
         */
        private String JCKJWDBZ;
        /**
         * 进出口经度
         */
        private String JCKJD;
        /**
         * 进出口纬度
         */
        private String JCKWD;
    }
}
