package com.icetech.open.domain.request.php;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 提供接口供PHP方调用，用于车辆二次识别结果通知；
 *
 * @author zhangpengzhan
 * @date 2020/7/3 14:48
 */
@Setter
@Getter
@ToString
public class RecognizeRequest {
    /**
     * 订单号
     */
    @NotNull
    private String orderNum;
    /**
     * 新的车牌号
     */
    @NotNull
    private String newPlateNum;
    /**
     * 新的置信度
     */
    @NotNull
    private int newReliability;
    /**
     * 新的车型(2大型车、1小型车)
     */
    private int newCarType;
}
