package com.icetech.open.domain.request.open;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Setter
@Getter
@ToString
public class PaidRecordFeeRequest {
    private String parkCode;
    @NotNull
    private String plateNum;
    @NotNull
    private Long startTime;
    @NotNull
    private Long endTime;
    private List<DeductionDetail> deductionDetails;

    @Setter
    @Getter
    @ToString
    public static class DeductionDetail implements Serializable {
        public int type;
        public String identify;
        public int minutes;
        public double amount;
    }

}
