package com.icetech.open.domain.request.open;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * 知位支付分账通知
 * @author fangct
 */
@Setter
@Getter
@ToString
public class IcepayDivisionOrderRequest {
    /**
     * 商户订单号
     */
    private String payOrderId;
    /**
     * 场库交易流水号
     */
    private String mchOderNo;
    /**
     * 入账方分账比例
     */
    private String divisionProfit;
    /**
     * 订单金额
     */
    private Integer payOrderAmount;
    /**
     * 订单分账金额
     */
    private Integer divisionAmount;
    /**
     * 分账时间
     */
    private String divisionTime;
    /**
     * 分账金额详情
     */
    private List<Detail> details;

    @Setter
    @Getter
    @ToString
    public static class Detail {
        /**
         * 收款商户号
         */
        private String mchNo;
        /**
         * 实际分账金额
         */
        private Integer actualDivisionAmount;
        /**
         * 手续费
         */
        private Integer mchFeeAmount;
    }
}
