package com.icetech.open.domain.request.open;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 出场通知接口
 * @author fangct
 */
@Setter
@Getter
@ToString
public class ExitSyncRequest {
    /**
     * 车场编号
     */
    @NotNull
    private String parkCode;
    /**
     * 通道编号
     */
    @NotNull
    private String channelCode;
    /**
     * 车牌号
     */
    @NotNull
    private String plateNum;
    /**
     * 出场时间，UNIX时间戳
     */
    @NotNull
    private Long exitTime;
    /**
     * 出场时间，UNIX时间戳
     */
    @NotNull
    private String paidPrice;
    /**
     * 出场时间，UNIX时间戳
     */
    @NotNull
    private Integer payWay;
}
