package com.icetech.open.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Setter
@Getter
@ToString
public class ExitRequest {
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    @ApiModelProperty(value = "停车场名称", required = true, example = "北辰停车场", position = 2)
    private String parkName;

    @ApiModelProperty(value = "订单号，确保订单号在此车场内的唯一性", required = true, example = "D1111111111", position = 3)
    private String orderNum;

    @ApiModelProperty(value = "车牌号", required = true, example = "京A88888", position = 4)
    private String plateNum;

    @ApiModelProperty(value = "入口名称", required = true, example = "南入口", position = 5)
    private String channelName;

    @ApiModelProperty(value = "出场时间（unix 10位时间戳）", required = true, example = "1657614044", position = 6)
    private Long exitTime;

    @ApiModelProperty(value = "停车时长（秒）", required = true, example = "111", position = 7)
    private Long parkTime;

    @ApiModelProperty(value = "车辆类型，详情查看数据定义部分", required = true, example = "1", position = 8)
    private Integer type;

    @ApiModelProperty(value = "车型，详情查看数据定义部分", required = true, example = "2", position = 9)
    private Integer carType;

    @ApiModelProperty(value = "应收总金额，从入场到出场产生的应收总费用", required = true, example = "10.00", position = 10)
    private Double totalAmount;

    @ApiModelProperty(value = "实收总金额，从入场到出场产生的实收总费用", required = true, example = "10.00", position = 11)
    private Double paidAmount;

    @ApiModelProperty(value = "优惠总金额，从入场到出场产生的优惠总费用", required = true, example = "10.00", position = 12)
    private Double discountAmount;

    @ApiModelProperty(value = "第三方优惠总金额", example = "10.00", position = 13)
    private Double outDiscAmount;

    @ApiModelProperty(value = "第三方实收总金额", example = "10.00", position = 14)
    private Double outPaidAmount;

    @ApiModelProperty(value = "云平台优惠总金额", example = "10.00", position = 15)
    private Double inDiscAmount;

    @ApiModelProperty(value = "云平台实收总金额", example = "10.00", position = 16)
    private Double inPaidAmount;

    @ApiModelProperty(value = "离场图片URL，注意：url有效期为30分钟", example = "", position = 17)
    private String imgUrl;
    
    /**
     * 小图
     */
    @ApiModelProperty(value = "离场小图图片URL，注意：url有效期为30分钟", example = "", position = 18)
    private String smallImgUrl;
    
    @ApiModelProperty(value = "车牌颜色", example = "", position = 19)
    private String plateColor;

    @ApiModelProperty(value = "是否异常离场，1:是", example = "1", position = 20)
    private Integer isExceptionExit;
}
