package com.icetech.open.domain.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Setter
@Getter
@ToString
public class EnterRequest {

    @ApiModelProperty(value = "车型，详情查看数据定义部分", required = true, example = "22", position = 1)
    private Integer carType;

    @ApiModelProperty(value = "入口名称", required = true, example = "南入口", position = 2)
    private String channelName;

    @ApiModelProperty(value = "进场时间（unix 10位时间戳）", example = "1657614044", position = 3)
    private Long enterTime;

    @ApiModelProperty(value = "订单号，确保订单号在此车场内的唯一性", required = true, example = "D1111111111", position = 4)
    private String orderNum;

    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 5)
    private String parkCode;

    @ApiModelProperty(value = "停车场名称", required = true, example = "北辰停车场", position = 6)
    private String parkName;

    @ApiModelProperty(value = "车牌号", required = true, example = "京A88888", position = 7)
    private String plateNum;

    @ApiModelProperty(value = "入场图片URL，注意：url有效期为30分钟", example = "", position = 8)
    private String imgUrl;
    /**
     * 小图
     */
    @ApiModelProperty(value = "入场小图图片URL，注意：url有效期为30分钟", example = "", position = 9)
    private String smallImgUrl;

    @ApiModelProperty(value = "车辆类型，详情查看数据定义部分", example = "2", position = 10)
    private Integer type;

    @ApiModelProperty(value = "无入场记录标识，0：否，1：是", example = "21", position = 11)
    private Integer noneEnterFlag = 0;

    @ApiModelProperty(value = "车牌颜色", example = "绿色", position = 12)
    private String plateColor;
    /**
     * 入场方式：1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场
     */
    @ApiModelProperty(value = "入场方式：1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场", example = "2", position = 13)
    private Integer enterWay;

}
