package com.icetech.open.domain.request.open;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 分秒-车辆入场-参数请求
 */
@Setter
@Getter
@ToString
public class EnterFmRequest {
    /**
     *每个场库的唯一编号(第三方 云分配)
     */
    private String parking_id;
    /**
     *车牌号
     */
    private String plate_num;
    /**
     *入场时间(yyyy-MM-dd HH:mm:ss)
     */
    private String in_time;
    /**
     *入场图片(url 或 Base64)
     */
    private String in_image;
    /**
     *车牌颜色(例如:蓝色)
     */
    private String car_color;
    /**
     *车牌类型（例如:92 式民用 车）
     */
    private String car_type;
    /**
     *入场通道名称
     */
    private String in_channel;
    /**
     *入场抬杆类型
     */
    private String in_open_gate_mode;
    /**
     *车辆入场时由第三方场库生成的唯一编 号
     */
    private String record_id;
    /**
     *时间戳(1970 年 01 月 01 日 00 时 00 分 00 秒到现在的毫秒值)
     */
    private String  timestamp;
}
