package com.icetech.open.domain.request.invoice;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 开蓝票
 * @author fangct
 */
@Getter
@Setter
@ToString
public class BlueInvoiceRequest implements Serializable {

    private Long parkId;
    /**
     * 交易流水号，有可能多个，用逗号隔开
     */
    @NotNull
    private String tradeNos;
    /** 抬头类型(1-个人;2-企业;) */
    @NotNull
    private Integer buyerTitleType;
    /** 纳税人识别号 */
    private String buyerTaxcode;
    @NotNull
    private String buyerTitle;

    private String buyerEmail;

    /**
     * 银行名称
     */
    private String bankName;
    /**
     * 银行账号
     */
    private String bankAccount;
    /**
     * 购买方地址
     */
    private String buyerAddress;
    /**
     * 购买方电话
     */
    private String buyerPhone;

    @NotNull
    private String amount;

    @NotNull
    private String productName;
    /**
     * 微信公众号的开票人的id
     */
    private Integer mpUserId;
    /**
     * 第三方开票订单记录id 第三方前缀加第三方传递参数组成
     */
    private String thirdId;
    /**
     * 来源 1=停车费 2=服务费 3=路内停车费 4=月卡续租
     */
    private int source;
    /**
     * 业务类型
     */
    private int bizType;
    /**
     * 服务商操作用户
     */
    private String operationUser;
    /**
     * 机构id
     */
    private Integer institutionId;
    /** 税价合计 */
    private String fee;
    /** 开票金额 */
    private String feeWithoutTax;
    /**
     *税额
     */
    private String tax;
    /**
     * 车牌号
     */
    private String plateNums;
    /**
     * 发票备注
     */
    private String invoiceRemark;

    /**
     * 订单时间
     */
    private Long exitTime;
}
