package com.icetech.open.domain.request.fenmiao;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class ParkingRequest<T> implements Serializable {
    /**
     *每个场库的唯一编号(第 三方云分配)
     */
    private String parking_id;
    /**
     *车牌号
     */
    private String plate_num;
    /**
     *车辆入场时由场库生成的 唯一编号
     */
    private String record_id;
    /**
     *时间戳(1970 年 01 月 01 日 00 时 00 分 00 秒到现在的 毫秒值)
     */
    private String timestamp;
    /**
     *本次实收金额(单位:分)
     */
    private String real_charge;
    /**
     *支付时间(格式:yyyy-MM-dd HH:mm:ss)
     */
    private String pay_time;
    /**
     *支付类型(例如:支付宝，微信，代扣)
     */
    private String pay_type;
    /**
     *支付订单编号
     */
    private String order_id;

    private List<FmWhiteRequest> data;
    /**
     *车道编号（用于控制具体的道闸）
     */
    private String lane_id;
    /**
     *操作类型（0 开闸 1 关闸 2 锁闸 3 解 锁）
     */
    private Integer operation_type;
    /**
     * 优惠券编码
     */
    private String coupon_code;
    /**
     * 优惠类型, 1 : 小时券, 2 : 金额券, 3 : 单次免费券
     */
    private String coupon_modeId;
    /**
     * 小时券,单位:分钟， 金额券 单位:分, 单次免费券可 不传
     */
    private String position;
    /**
     * 支付订单
     */
    private String order_no;

    private String passageway_id;
    /**
     * 临时车牌
     */
    private String spell_plate_num;
}
