package com.icetech.open.domain.request.fenmiao;

import lombok.Data;

import java.io.Serializable;

@Data
public class FmEnterRequest implements Serializable {
    /**
     *每个场库的唯一编号(第 三方云分配)
     * 必填
     */
    private String parking_id;
    /**
     *车牌号
     * 必填
     */
    private String plate_num;
    /**
     *车辆入场时由场库生成的 唯一编号
     * 必填
     */
    private String record_id;
    /**
     *入场时间(yyyy-MM-dd HH:mm:ss)
     * 必填
     */
    private String in_time;
    /**
     *入场图片(url 或 Base64)
     * 必填
     */
    private String in_image;
    /**
     *车牌颜色(例如:蓝色)
     */
    private String car_color;
    /**
     *支付类型(例如:支付宝，微信，代扣)
     */
    private String pay_type;
    /**
     *入场通道名称
     */
    private String in_channel;
    /**
     * 入场抬杆类型
     */
    private String in_open_gate_mode;
    /**
     *时间戳(1970 年 01 月 01 日 00 时 00 分 00 秒到现在的毫秒值)
     * 必填
     */
    private String timestamp;

}
