package com.icetech.open.domain.enumeration;

import lombok.Getter;

/**
 * 高灯发票接口专用省份对应表
 */
@Getter
public enum GoldenProvince {
    北京市("11", "北京市"),
    上海市("31", "上海市"),
    天津市("12", "天津市"),
    河北省("13", "河北省"),
    山西省("14", "山西省"),
    内蒙古自治区("15", "内蒙古自治区"),
    辽宁省("21", "辽宁省"),
    吉林省("22", "吉林省"),
    黑龙江省("23", "黑龙江省"),
    江苏省("32", "江苏省"),
    浙江省("33", "浙江省"),
    安徽省("34", "安徽省"),
    福建省("35", "福建省"),
    江西省("36", "江西省"),
    山东省("37", "山东省"),
    河南省("41", "河南省"),
    湖北省("42", "湖北省"),
    湖南省("43", "湖南省"),
    广东省("44", "广东省"),
    广西壮族自治区("45", "广西壮族自治区"),
    海南省("46", "海南省"),
    重庆市("50", "重庆市"),
    ;
    private String code;
    private String name;

    private GoldenProvince(String code, String name){
        this.code = code;
        this.name = name;
    }

    public static String getCode(String name) {
        for (GoldenProvince p : GoldenProvince.values()) {
            if (p.getName().indexOf(name) >= 0) {
                return p.code;
            }
        }
        return "";
    }
}
