package com.icetech.open.domain;

import lombok.Data;
import org.apache.commons.collections4.MapUtils;

import java.util.Map;

/**
 * 无锡智慧停车推送参数
 *
 * @author FGD
 */
@Data
public class WuXiThirdInfoParam {
    /**
     * <p>账户</p>
     * <p>必填: 是</p>
     */
    protected String username;
    /**
     * <p>密码</p>
     * <p>必填: 是</p>
     */
    protected String password;

    /**
     * Token有效时间(ms)
     */
    protected Long tokenExpireMillis;

    /**
     * Token有效时间偏移(ms)
     */
    protected Long tokenExpireOffset;

    /**
     * 加密密钥
     */
    protected String secretKey;

    /**
     * 加密偏移量
     */
    protected String secretOffset;
    /**
     * <p>key: parkCode</p>
     * <p>value: 平台编号(platformNo)</p>
     */
    protected Map<String, String> parkCodes;

    public String getPlatformNo(String parkCode) {
        return MapUtils.getString(parkCodes, parkCode);
    }
//    /**
//     * <p>平台编号(platformNo)</p>
//     * <p>必填: 是</p>
//     * <p>eq pno</p>
//     */
//    protected String platformNo;
}
